var Poi3dDocumentLoader = new function()
{
  var _poi3dAdapter = null;
  var _cmiWindow = null;

  this.setPoi3dAdapter = function(newPoi3dAdapter){_poi3dAdapter = newPoi3dAdapter;};
  this.setCmiWindow = function(newCmiWindow ){_cmiWindow  = newCmiWindow ;};
 
  function _addAttributes(poi3dDocument,metaData)
  {
    let attSets = poi3dDocument.getDocAttributes();
    
    let newSet = new Poi3dDocAttributeSet();
    newSet.setIsTopFlag(true);
    
    let attributes = newSet.getAttrArray();
    let newAtt = null;
    let ttl = "";
    let val = "";

    for(var entry in Object.keys(metaData))
    {        
      ttl = Object.keys(metaData)[entry];
      if(ttl != undefined)
      {
        ttl=ttl.toString();

        val = metaData[ttl];
        if(val != undefined)
        {
          val=val.toString();

          newAtt = new Poi3dDocAttribute();
          newAtt.setKey(ttl);
          newAtt.setTitle(ttl);
          newAtt.setValue(val);
          attributes.push(newAtt);
        }//if(val != undefined)
      }//if(ttl != undefined)
    }//for(var entry in Object.keys(metaData));
    
    if(attributes.length >0)
      attSets.push(newSet);      
  };
  
  this.selectFile = function(whichSide)
  {
    var inputElement = document.createElement('input');
    inputElement.type = 'file';

    inputElement.accept=".wpm,.jpg,.bmp,.gif,.svg,.png,.tif,.tiff,.pdf";

    inputElement.onchange = e =>
    {
      var fileToOpen = e.target.files[0]

      if(whichSide == "right")
        this.createRightDocumentFromFileTarget(fileToOpen);
      else
      {
        exifr.parse(fileToOpen)
        .then(metadata =>
        {
          //console.log(metadata);
          this.createLeftDocumentFromFileTarget(fileToOpen, metadata);      
  
        })
        .catch(error =>
        {
          this.createLeftDocumentFromFileTarget(fileToOpen,null);      
        });
      }
    }
    inputElement.click();
  };

  this.loadFileIntoViewer = function(fileUrl,fileTarget,fileTitle)
  {
    let fileUrlLC = "";
    let fileNameToOpen = fileUrl;
    let docType = "";
    
    //http://localhost/poi3dDev/Portal/Poi3dViewer.html?dbId=12340&dbAccess=http://localhost/poi3dDev
    
    if(fileUrl != null)
    {
      if(fileUrl.includes("dbId:"))
      {
        let accessUrl = "";
        let dbId = "";
        setStatusText(poi3dConnector.getStatusText(7));//"Loading document"
        
        if(fileUrl.includes("accessUrl"))//cross domain access -> get data via embedded iframe
        {
          accessUrl = fileUrl.split(",")[1].split(":").pop();
          dbId = fileUrl.split(",")[0].split(":").pop();
          
          var accessFrame = document.getElementById("storageConnector");
          accessFrame.src = accessUrl + "/Poi3d/StorageConnectors/Poi3dMessageConnector.html?dbId=" + dbId;
        }
        else//same domain access -> DB directly acessible
        {
          dbId = fileUrl.split(":").pop();
                  
          Poi3dHelpers.readDocumentFromBrowserDb(dbId).then
          (
            function(value)
            {
              let messageObject = null;
              messageObject = {cmd:"CMI_INFO|DbInfoFromStorage|",value:value};
              window.postMessage(messageObject);
            }//function(value)
          );//Poi3dHelpers.readDocumentFromBrowserDb(dbId).then
        }//if(fileUrl.includes("accessUrl")) else
      }//if(fileUrl.includes("dbId:"))
      else 
      {
        fileUrlLC = fileUrl.toLowerCase();        
        if(fileUrlLC.includes(".wpm"))
        {
          docType = "wpm";
          if(viewingMode == "2d") viewingMode = "3d";
          resizeWindow(false);
  
          _cmiWindow.loadModelFromUrl(fileUrl,false,true); //keep used templates
        }
        else
        {
          if((fileUrlLC.includes('.tif')==true)||fileUrlLC.includes("data:image/tiff")==true) docType = "tif";
          else if((fileUrlLC.includes('.pdf')==true)||fileUrlLC.includes("data:application/pdf")==true) docType = "pdf";
            
          if(viewingMode == "3d") viewingMode = "2d";
          resizeWindow(false);
  
          open2dImage(fileNameToOpen, fileTitle, docType, false);
        }
      }//if(fileUrl.includes("dbId:")) else
    }
    else if(fileTarget != null)
    {
      fileUrlLC = fileTarget.name.toLowerCase();

      if(fileUrlLC.includes(".wpm"))
      {
        docType = "wpm";
        if(viewingMode == "2d") viewingMode = "3d";
        resizeWindow(false);

        _cmiWindow.openModelFromLocalFile(fileTarget,false,true);
      }
      else
      {
        if((fileUrlLC.includes('.tif')==true)||fileUrlLC.includes("data:image/tiff")==true) docType = "tif";
        else if((fileUrlLC.includes('.pdf')==true)||fileUrlLC.includes("data:application/pdf")==true) docType = "pdf";

        if(viewingMode == "3d") viewingMode = "2d";
        resizeWindow(false);

        var oFReader = new FileReader();
        oFReader.readAsDataURL(fileTarget);

        oFReader.onload = function (oFREvent)
        {                          
          open2dImage(oFREvent.target.result, fileTitle, docType, false);
        };
      }
    }
  };//Poi3dDocumentLoader.loadFileIntoViewer

  this.createLeftDocumentFromFileUrl = function(fileUrl, externalId)
  {
    resetViewer(false);
    _cmiWindow.currentCommand = "OpenMod";
  

    let poi3dDocument = new Poi3dDocument();
    poi3dDocument.initializeAttachments(_poi3dAdapter.getPoi3dUser());

    _poi3dAdapter.setLeftDocumentUrl(fileUrl);
    _poi3dAdapter.setLeftFileTarget(null);
    _poi3dAdapter.setLeftDocument(poi3dDocument);

    poi3dDocument.setDocLocation(4);
    if(externalId != undefined)
    {
      poi3dDocument.setDocLocation(5);
      poi3dDocument.setExternalId(externalId);
      updatePortalUi();
    }

    let fileTitle = fileUrl.split("/").slice(-1).join().split(".").shift();

    exifr.parse(fileUrl)
    .then(metaData =>
    {
      //console.log(metaData);
      _addAttributes(poi3dDocument,metaData);
    })
    .catch(error =>
    {
    });

    this.loadFileIntoViewer(fileUrl,null,fileTitle);
    _poi3dAdapter.setCurrentWgOrCatalog(null);
  };//Poi3dDocumentLoader.createLeftDocumentFromFileUrl

  this.createLeftDocumentFromFileTarget = function(fileTarget, metaData)
  {
    let fileNameArray = fileTarget.name.toLowerCase().split(".");
    let fileTitle = fileNameArray[fileNameArray.length - 2];

    resetViewer(false);
    _cmiWindow.currentCommand = "OpenMod";

    let poi3dDocument = new Poi3dDocument();
    poi3dDocument.initializeAttachments(_poi3dAdapter.getPoi3dUser());
    _poi3dAdapter.setLeftDocumentUrl("");
    _poi3dAdapter.setLeftFileTarget(fileTarget);
    _poi3dAdapter.setLeftDocument(poi3dDocument);
    poi3dDocument.setDocLocation(4);
    
    if(metaData != null)
    {
      _addAttributes(poi3dDocument,metaData);
    }

    this.loadFileIntoViewer(null,fileTarget,fileTitle);
    _poi3dAdapter.setCurrentWgOrCatalog(null);
  };//Poi3dDocumentLoader.createLeftDocumentFromFileTarget

  this.createRightDocumentFromFileTarget = function(fileTarget)
  {
    let fileNameArray = fileTarget.name.toLowerCase().split(".");
    let fileTitle = fileNameArray[fileNameArray.length - 2];

    rightModel = null;
    _cmiWindow.resetCmiModel();
    _cmiWindow.currentCommand = "OpenCmpMod";

    let poi3dDocument = new Poi3dDocument();
    _poi3dAdapter.setRightFileTarget(fileTarget);
    _poi3dAdapter.setRightDocument(poi3dDocument);
    poi3dDocument.setDocLocation(4);

    this.loadFileIntoViewer(null,fileTarget,fileTitle);
  };//Poi3dDocumentLoader.createRightDocumentFromFileTarget

  this.openLeftDocumentFromExternalStorage = function(documentUrl)
  {
    let poi3dDocument = new Poi3dDocument();
    poi3dDocument.openFromExternalStorage(documentUrl,_poi3dAdapter.getPoi3dUser());
  };//Poi3dDocumentLoader.openLeftDocumentFromExternalStorage

  this.createLeftDocumentFromBrowserDbId = function(dbId,dbAccessUrl)
  {
    let fileUrl = "dbId:"+dbId;
    if(dbAccessUrl.length > 0)
      fileUrl = fileUrl + ",accessUrl:"+dbAccessUrl;
    
    resetViewer(false);
    _cmiWindow.currentCommand = "OpenMod";

    let poi3dDocument = new Poi3dDocument();
    poi3dDocument.initializeAttachments(_poi3dAdapter.getPoi3dUser());

    _poi3dAdapter.setLeftDocumentUrl(fileUrl);
    _poi3dAdapter.setLeftFileTarget(null);
    _poi3dAdapter.setLeftDocument(poi3dDocument);

    poi3dDocument.setDocLocation(7);
    poi3dDocument.setExternalId(dbId);
    updatePortalUi();

    this.loadFileIntoViewer(fileUrl,null,null);
    _poi3dAdapter.setCurrentWgOrCatalog(null);
  };//Poi3dDocumentLoader.createLeftDocumentFromBrowserDbId

  this.openLeftDocumentByAccessKey = function(accessKey)
  {
    if(accessKey.length >0)
    {
      let poi3dDocument = new Poi3dDocument();
      poi3dDocument.openByAccessKey(accessKey,_poi3dAdapter.getPoi3dUser());
    }
  };//Poi3dDocumentLoader.openLeftDocumentByAccessKey

  this.loadPrimaryDocument = function(cmiWindow,poi3dDocument)
  {
    let modelUrlToLoad = "";
    let modelNameToLoad = "";

    modelUrlToLoad = poi3dDocument.getDocUrl(_poi3dAdapter.getPoi3dUser(),"read");

    //modelNameToLoad = poi3dDocument.getTitle();
    modelNameToLoad = poi3dDocument.getDocFileName();

    if(_poi3dAdapter.getLeftDocument() != null)
      _poi3dAdapter.getLeftDocument().getSensorObject().removeHtmlObjects();

    _poi3dAdapter.setLeftDocument(poi3dDocument);
    this.loadDocumentFile(modelUrlToLoad,modelNameToLoad);

  };//Poi3dDocumentLoader.loadPrimaryDocument

  this.loadSecondaryDocument = function(cmiWindow,poi3dDocument)
  {
    let modelUrlToLoad = "";
    let modelNameToLoad = "";

    modelUrlToLoad = poi3dDocument.getDocUrl(_poi3dAdapter.getPoi3dUser(),"read");
    //modelNameToLoad = poi3dDocument.getTitle();
    modelNameToLoad = poi3dDocument.getDocFileName();

    _poi3dAdapter.setRightDocument(poi3dDocument);

    this.loadDocumentFile(modelUrlToLoad,modelNameToLoad);

  };//Poi3dDocumentLoader.loadSecondaryDocument

  this.loadDocumentFile = function(fileUrlToLoad,fileNameToLoad)
  {
    let fileUrlToLoadLC = fileUrlToLoad.toLowerCase();

    if(fileUrlToLoadLC.includes(".wpm"))
      load3dWpmModel(fileUrlToLoad);
    else if(fileUrlToLoadLC.includes(".zip"))
      load3dWpmModel(fileUrlToLoad);
    else if(fileUrlToLoadLC.includes(".jpg"))
      load2dImage(fileUrlToLoad,fileNameToLoad);
    else if(fileUrlToLoadLC.includes(".jpeg"))
      load2dImage(fileUrlToLoad,fileNameToLoad);
    else if(fileUrlToLoadLC.includes(".bmp"))
      load2dImage(fileUrlToLoad,fileNameToLoad);
    else if(fileUrlToLoadLC.includes(".gif"))
      load2dImage(fileUrlToLoad,fileNameToLoad);
    else if(fileUrlToLoadLC.includes(".svg"))
      load2dImage(fileUrlToLoad,fileNameToLoad);
    else if(fileUrlToLoadLC.includes(".png"))
      load2dImage(fileUrlToLoad,fileNameToLoad);
    else if(fileUrlToLoadLC.includes(".tif"))
      load2dImage(fileUrlToLoad,fileNameToLoad);
    else if(fileUrlToLoadLC.includes(".pdf"))
      load2dImage(fileUrlToLoad,fileNameToLoad);
  };//Poi3dDocumentLoader.loadDocumentFile

};//Poi3dDocumentLoader

function load3dWpmModel(modelUrlToLoad,register)//called by windows client 1.0
{
  var modelUrl = modelUrlToLoad;
  if(modelUrlToLoad.includes("file="))
  {
    let modelUrlArray = modelUrlToLoad.split("file=");
    modelUrl = modelUrlArray[1];
  }

  if(myCmiWindow.currentCommand == "OpenCmpMod")
  {
    rightModel = null;
    myCmiWindow.resetCmiModel();
  }
  else
  {
    resetViewer(false);
    if(viewingMode == "2d") viewingMode = "3d";

    if(register)
    {
      poi3dConnector.setLeftDocument(new Poi3dDocument());
      poi3dConnector.setLeftDocumentUrl(modelUrlToLoad);
      poi3dConnector.setLeftFileTarget(null);
    }
  }
  resizeWindow(false);

  modelNameFromZip = "";

  if(modelUrl.includes(".wpm"))
  {
    myCmiWindow.loadModelFromUrl(modelUrlToLoad,false,true); //keep used templates
    return;
  }
  else if(modelUrl.includes(".zip") == false)
  {
    setStatusText(poi3dConnector.getStatusText(11));//"Unsupported extension"
    return;
  }

  var modelDir = modelUrl.substring(0,modelUrl.lastIndexOf("/"));
  JSZipUtils.getBinaryContent(modelUrlToLoad,
  {
    progress: function(e)
    {
      if(e.percent != Infinity)
        setStatusText(e.percent.toFixed(0) + "% received");
      else
        setStatusText(e.loaded + " bytes received");        
    },//progress: function(e)
    callback: function (err, data)
    {
      if(err)
        setStatusText(err.message);
      else if(data.byteLength == 0)
        setStatusText("Error getting zip file");
      else
        loadWpmFromZip(data,modelDir);

    }//callback: function (err, data)
  });//JSZipUtils.getBinaryContent(modelUrl,
}//function load3dWpmModel(wpmUrl)

function loadWpmFromZip(zipData,modelDir)
{
  myCmiWindow.getCmiModel().setModelDirectory(modelDir);

  JSZip.loadAsync(zipData).then(function (zip)
  {
    var cnt=0;
    var foundWpm = false;
    for (filename in zip.files)
    {
      cnt++;
      if(filename.includes(".wpm"))
        foundWpm = true;
    }

    if(cnt != 1)
    {
      setStatusText(poi3dConnector.getStatusText(12));//"More or less than one files in zip"
      return;
    }

    if(foundWpm == false)
    {
      setStatusText(poi3dConnector.getStatusText(13));//"No wpm file found in zip"
      return;
    }

    setStatusText(poi3dConnector.getStatusText(15));//"Extracting from zip"

    zip.forEach(function (relativePath, zipFileContent)
    {
      if(zipFileContent.name.includes(".wpm"))
      {
        zipFileContent.async("string")
        .then(function success(content,username)
        {
          modelNameFromZip = relativePath.replace(".wpm","");

          var utf8String =content;
          if(content.charCodeAt(0) === 0xFEFF)
            {utf8String = content.substr(1);}

          myCmiWindow.openModelFromJsonString(utf8String,false,true); //keep used templates
        },
        function error(e)
        {
          setStatusText(poi3dConnector.getStatusText(14));//"Wrong format in zip file"
        });
      };//if(zipFileContent.name.includes(".wpm"))
    });//zip.forEach(
  })//JSZip.loadAsync.then
  .catch
  (
    err => setStatusText(err)
  );//JSZip.loadAsync
};//function loadWpmFromZip

function load2dImage(imgUrl,modelName,register)//called by windows client 1.0
{
  let docType = "";
  resetViewer(false);

  if(register)
  {
    poi3dConnector.setLeftDocument(new Poi3dDocument());
    poi3dConnector.setLeftDocumentUrl(imgUrl);
    poi3dConnector.setLeftFileTarget(null);
  }

  if((imgUrl.includes('.tif')==true)||imgUrl.includes("data:image/tiff")==true) docType = "tif";
  else if((imgUrl.includes('.pdf')==true)||imgUrl.includes("data:application/pdf")==true) docType = "pdf";

  open2dImage(imgUrl, modelName, docType, false);
};//function load2dImage

/*
function loadZippedWpmModelFromFile(fileTarget)
{
  var fileNameArray = fileTarget.name.toLowerCase().split(".");
  var fileName = fileNameArray[fileNameArray.length - 2];
  var fileExtension = fileNameArray[fileNameArray.length - 1];

  if(myCmiWindow.currentCommand == "OpenCmpMod")
  {
    rightModel = null;
    myCmiWindow.resetCmiModel();

    poi3dConnector.setRightDocument(new Poi3dDocument());
    poi3dConnector.setRightFileTarget(fileTarget);
  }
  else
  {
    resetViewer(false);

    poi3dConnector.setLeftDocument(new Poi3dDocument());
    poi3dConnector.setLeftFileTarget(fileTarget);
  }
  resizeWindow(false);

  var reader = new FileReader();
  reader.onload = () =>
  {
    loadWpmFromZip(reader.result,"");
  }
  reader.readAsBinaryString(fileTarget);
};//function loadZippedWpmModelFromFile
*/
