var Poi3dHostInterface = new function()
{
  var _poi3dAdapter = null;
  var _hostOrigin= "";
  var _isCallFromIframeHost = false;
  var _controlVersion = 1.1;

  this.setControlVersion = function(controlVersion)
  {
    if(typeof controlVersion === 'string')
      _controlVersion = parseFloat(controlVersion);
    else
      _controlVersion = controlVersion;
  };//Poi3dHostInterface.setControlVersion

  this.setHostOrigin= function(newHostOrigin)
  {
    _hostOrigin = newHostOrigin;
  };//Poi3dHostInterface.setHostOrigin

  this.setPoi3dAdapter = function(newPoi3dAdapter)
  {
    _poi3dAdapter = newPoi3dAdapter;
    //window.document.addEventListener("poi3dDocMsgEvent", Poi3dHostInterface.handleHostMsgEvent, false);//dispatchEvent call
    window.addEventListener("message", Poi3dHostInterface.handleHostMsgEvent, false); //postMessage call
  };//Poi3dHostInterface.setPoi3dAdapter

  this.handleHostMsgEvent = function (evt)
  {
    let evtObj = null;

    if((event.origin != undefined)&&(event.origin !== _hostOrigin)) return;
    if((event.detail != undefined)) evtObj = event.detail; //dispatchEvent call
    else if((event.data != undefined)) evtObj = event.data; //postMessage call

    _isCallFromIframeHost = true;

    switch (evtObj.cmd)
    {
      //0 parameter
      case "getDocIdsFromLoadedDocument":
        Poi3dHostInterface.getDocIdsFromLoadedDocument();
        break;
      case "getDocumentAccessKey":
        Poi3dHostInterface.getDocumentAccessKey();
        break;
      case "getDocumentAnnotations":
        Poi3dHostInterface.getDocumentAnnotations();
        break;
      case "getDocumentAttributes":
        Poi3dHostInterface.getDocumentAttributes();
        break;
      case "getDocumentBomStructures":
        Poi3dHostInterface.getDocumentBomStructures();
        break;
      case "getDocumentFileAttachments":
        Poi3dHostInterface.getDocumentFileAttachments();
        break;
      case "getDocumentInstructions":
        Poi3dHostInterface.getDocumentInstructions();
        break;
      case "getDocumentMaterialSets":
        Poi3dHostInterface.getDocumentMaterialSets();
        break;
      case "getDocumentSensors":
        Poi3dHostInterface.getDocumentSensors();
        break;
      case "getDocumentViewLocations":
        Poi3dHostInterface.getDocumentViewLocations();
        break;
      case "saveDocumentAttachementsToPortal":
        Poi3dHostInterface.saveDocumentAttachementsToPortal();
        break;
      case "exitPortal":
        Poi3dHostInterface.exitPortal();
        break;
      case "logOff":
        Poi3dHostInterface.logOff();
        break;
        //1 parameter
      case "setDocumentAnnotations":
        Poi3dHostInterface.setDocumentAnnotations(evtObj.params[0]);
        break;
      case "setDocumentAttributes":
        Poi3dHostInterface.setDocumentAttributes(evtObj.params[0]);
        break;
      case "setDocumentBomStructures":
        Poi3dHostInterface.setDocumentBomStructures(evtObj.params[0]);
        break;
      case "setDocumentFileAttachments":
        Poi3dHostInterface.setDocumentFileAttachments(evtObj.params[0]);
        break;
      case "setDocumentInstructions":
        Poi3dHostInterface.setDocumentInstructions(evtObj.params[0]);
        break;
      case "setDocumentMaterialSets":
        Poi3dHostInterface.setDocumentMaterialSets(evtObj.params[0]);
        break;
      case "setDocumentSensors":
        Poi3dHostInterface.setDocumentSensors(evtObj.params[0]);
        break;
      case "setDocumentViewLocations":
        Poi3dHostInterface.setDocumentViewLocations(evtObj.params[0]);
        break;
      case "openLeftUserDocumentByAccessKey":
        Poi3dHostInterface.openLeftUserDocumentByAccessKey(evtObj.params[0]);
        break;
      //2 parameter
      case "openLeftDocument":
        Poi3dHostInterface.openLeftDocument(evtObj.params[0],evtObj.params[1]);
        break;
      case "setStatusText":
        Poi3dHostInterface.setStatusText(evtObj.params[0],evtObj.params[1]);
        break;
      case "showMsgDlg":
        Poi3dHostInterface.showMsgDlg(evtObj.params[0],evtObj.params[1]);
        break;
      //3 parameter
      case "logIn":
        Poi3dHostInterface.logIn(evtObj.params[0],evtObj.params[1],evtObj.params[2]);
        break;
      //4 parameter
      case "createUser":
        Poi3dHostInterface.createUser(evtObj.params[0],evtObj.params[1],evtObj.params[2],evtObj.params[3]);
        break;
      case "saveCurrentDocument":
        Poi3dHostInterface.saveCurrentDocument(evtObj.params[0],evtObj.params[1],evtObj.params[2],evtObj.params[3]);
        break;
    }

    _isCallFromIframeHost = false;

  };//Poi3dHostInterface.handleDocMsgEvent

  this.buildReturnString = function (cmdString, dataString, callStateString)
  {
    return JSON.stringify(this.buildReturnObject(cmdString, dataString, callStateString));
  };//Poi3dHostInterface.buildReturnString

  this.buildReturnObject = function (cmdString, dataString, callStateString)
  {
    let returnObject = null;
    let dataStringVal = "";

    if(dataString != undefined)
      dataStringVal = dataString;

    if((callStateString != undefined)&&(callStateString.length > 0))
    {
      let callStateObj = JSON.parse(callStateString.replaceAll("'", "\""));
      returnObject = {cmd:cmdString,errCode:callStateObj.errCode,errText:callStateObj.errText,info:dataStringVal};
    }
    else
    {
      returnObject = {cmd:cmdString,errCode:0,errText:"",info:dataStringVal};
    }

    return returnObject;
  };//Poi3dHostInterface.buildReturnObject

  this.sendMessageToHost = function (cmdString, dataString, callStateString)
  {
    let hostIdVal = "";
    let poi3dIdVal = "";
    let poi3dUserIdVal = "";
    let dataStringVal = "";

    if(dataString != undefined)
      dataStringVal = dataString;

    if((_poi3dAdapter!=null)&&(_poi3dAdapter.getLeftDocument() != null))
    {
      hostIdVal = _poi3dAdapter.getLeftDocument().getExternalId();
      poi3dIdVal = _poi3dAdapter.getLeftDocument().getDocId();
    }

    if((_poi3dAdapter!=null)&&(_poi3dAdapter.getPoi3dUser() != null))
      poi3dUserNameVal = _poi3dAdapter.getPoi3dUser().getAliasName();

    let messageObject = null;
    let callStateObj = null;
    if((callStateString != undefined)&&(callStateString.length > 0))
    {
      callStateObj = JSON.parse(callStateString.replaceAll("'", "\""));
      messageObject = {cmd:cmdString,hostId:hostIdVal,poi3dId:poi3dIdVal,poi3dUserName:poi3dUserNameVal,callState:callStateObj,info:dataStringVal};
    }
    else
    {
      messageObject = {cmd:cmdString,hostId:hostIdVal,poi3dId:poi3dIdVal,poi3dUserName:poi3dUserNameVal,info:dataStringVal};
    }

    if((window.chrome != undefined) && (window.chrome.webview != undefined))//Client connection
    {
      if(callStateObj != null)//Error information is packed directly in C# Poi3dMessage object
        messageObject = {cmd:cmdString,hostId:hostIdVal,poi3dId:poi3dIdVal,poi3dUserName:poi3dUserNameVal,errCode:callStateObj.errCode,errText:callStateObj.errText,info:dataStringVal};

      let messageString = JSON.stringify(messageObject);
      window.chrome.webview.postMessage(messageString);
    }
    else if(window.parent != window)//iFrame connection
    {
      //dispatchEvent call
      //let event = new CustomEvent("poi3dDocMsgEvent", { detail: messageObject })
      //window.parent.document.dispatchEvent(event);

      if(_hostOrigin.length > 0)
        window.parent.postMessage(messageObject,_hostOrigin);
      else
        window.parent.postMessage(messageObject);
    }
  };//Poi3dHostInterface.sendMessageToHost

  this.exitPortal = function()
  {
    this.logOff();
  };//Poi3dHostInterface.exitPortal

  this.logIn = function (uAlias, uPwd, uToken)
  {
    let retVal = "";
    let callState = "{'errCode':0,'errText':''}";

    if(uToken == undefined) uToken = "";

    if((uAlias == undefined)||(uPwd == undefined))
    {
      callState = "{'errCode':-1,'errText':'Not enough parameters given'}";
      Poi3dHostInterface.sendMessageToHost("LoginError", "", callState);
      return;
    }

    _poi3dAdapter.getPoi3dUser().loadUserBaseInformation(uAlias,uPwd,uToken);
  };//Poi3dHostInterface.logIn

  this.createUser = function (uName, uPwd, uMail, isAuthor)
  {
    let retVal = "";
    let callState = "{'errCode':0,'errText':''}";

    if((uName == undefined)||(uPwd == undefined)||(uMail == undefined)||(isAuthor == undefined))
    {
      callState = "{'errCode':-1,'errText':'Not enough parameters given'}";
      Poi3dHostInterface.sendMessageToHost("CreateUserError", "", callState);
      return;
    }

    let uType = "u";
    if((isAuthor == "true")||(isAuthor == true))
      uType = "c";

    if((_poi3dAdapter==null)||(_poi3dAdapter.getPoi3dUser() == null)||(_poi3dAdapter.getPoi3dUser().isAdmin() == false))
    {
      callState = "{'errCode':-1,'errText':'No admin logged in'}";
      Poi3dHostInterface.sendMessageToHost("CreateUserError","", callState);
    }
    else if(_poi3dAdapter.isValidUserName(uName)==false)
    {
      callState = "{'errCode':-1,'errText':'Invalid user name'}";
      Poi3dHostInterface.sendMessageToHost("CreateUserError","", callState);
    }
    else if(_poi3dAdapter.isValidPassword(uPwd)==false)
    {
      callState = "{'errCode':-1,'errText':'Invalid password'}";
      Poi3dHostInterface.sendMessageToHost("CreateUserError","", callState);
    }
    else if(_poi3dAdapter.isValidEmail(uMail)==false)
    {
      callState = "{'errCode':-1,'errText':'Invalid email'}";
      Poi3dHostInterface.sendMessageToHost("CreateUserError","", callState);
    }
    else
      poi3dConnector.createUser(uName,uPwd,uMail,uType,false);

  };//Poi3dHostInterface.createUser

  this.saveCurrentDocument = function (dTitle, dDesc, useFrontAsTop, isPublic)
  {
    let retVal = "";
    let callState = "{'errCode':0,'errText':''}";

    if((dTitle == undefined)||(dDesc == undefined)||(useFrontAsTop == undefined)||(isPublic == undefined))
    {
      callState = "{'errCode':-1,'errText':'Not enough parameters given'}";
      Poi3dHostInterface.sendMessageToHost("SaveCurrentDocumentError", "", callState);
      return;
    }

    let isPublicVal = false;
    if((isPublic == "true")||(isPublic == true))
      isPublicVal = true;

    let useFrontAsTopVal = false;
    if((useFrontAsTop == "true")||(useFrontAsTop == true))
      useFrontAsTopVal = true;

    if((_poi3dAdapter==null)||(_poi3dAdapter.checkUserAccess() == false))
    {
      callState = "{'errCode':-1,'errText':'No user logged in'}";
      Poi3dHostInterface.sendMessageToHost("SaveCurrentDocumentError","", callState);
      return;
    }

    if(_poi3dAdapter.isMaximumReached("maxDoc"))
    {
      callState = "{'errCode':-1,'errText':'Maximum number of documents reached'}";
      Poi3dHostInterface.sendMessageToHost("SaveCurrentDocumentError","", callState);
      return;
    }

    let currDoc = _poi3dAdapter.getLeftDocument();
    if(currDoc == null)
    {
      callState = "{'errCode':-1,'errText':'No document opened'}";
      Poi3dHostInterface.sendMessageToHost("SaveCurrentDocumentError","", callState);
       return;
    }

    switch(currDoc.getDocLocation())
    {
      case 1: //internal catalog
      case 2: //external catalog
      case 3: //sample
      case 6: //public internal
        callState = "{'errCode':-1,'errText':'Document not saveable'}";
        Poi3dHostInterface.sendMessageToHost("SaveCurrentDocumentError","", callState);
        return;
      case 4: //external url
      case 5: //from host
        if(_poi3dAdapter.getPoi3dUser().isDocHostedAndSaved(currDoc))
        {
          callState = "{'errCode':-1,'errText':'Document not saveable'}";
          Poi3dHostInterface.sendMessageToHost("SaveCurrentDocumentError","", callState);
        }
        break;
    }

    currDoc.setTitle(dTitle);
    currDoc.setDescription(dDesc);
    currDoc.setUseFrontAsTop(useFrontAsTopVal);
    currDoc.setPublicState(isPublicVal);

    if(currDoc.getLoadState() == false)//save newly
    {
      if(_poi3dAdapter.getPoi3dUser().isDocHostedAndSaved(currDoc))
      {
        callState = "{'errCode':-1,'errText':'Document already saved'}";
        Poi3dHostInterface.sendMessageToHost("SaveCurrentDocumentError","", callState);
      }
      else
        _poi3dAdapter.saveNewDocumentToStorage(currDoc,_poi3dAdapter.getLeftFileTarget(),"apiCall");
    }
    else //update
    {
      currDoc.setDocState("changed");
      _poi3dAdapter.saveDocumentListToStorage("apiCall");
    }
  };//Poi3dHostInterface.saveCurrentDocument

  this.logOff = function ()
  {
    let retVal = "";
    let callState = "{'errCode':0,'errText':''}";

    if(_poi3dAdapter.getPoi3dUser().isLoggedIn() == true)
      _poi3dAdapter.logOff();
    else
    {
      callState = "{'errCode':-1,'errText':'No user logged in'}";
      Poi3dHostInterface.sendMessageToHost("LogoffError", "", callState);
      return;
    }
  };//Poi3dHostInterface.logOff

  this.openLeftDocument = function (documentUrl, externalId)
  {
    let retVal = "";
    let callState = "{'errCode':0,'errText':''}";

    if((documentUrl == undefined)||(externalId == undefined))
    {
      callState = "{'errCode':-1,'errText':'Not enough parameters given'}";
      Poi3dHostInterface.sendMessageToHost("OpenLeftDocumentError", "", callState);
      return;
    }

    Poi3dDocumentLoader.createLeftDocumentFromFileUrl(documentUrl, externalId);
  };//Poi3dHostInterface.openLeftDocument

  this.getDocumentAccessKey = function ()
  {
    let retVal = "";
    let callState = "{'errCode':0,'errText':''}";
    let currDoc = _poi3dAdapter.getLeftDocument();

    if(
    (_poi3dAdapter!=null)&&
    (currDoc != null)&&
    (currDoc.getDocState() == "loaded")&&
    (_poi3dAdapter.checkUserAccess() == true)
    )
    {
      let accessUrl = poi3dConnector.getCurrentDocumentAccessUrl(_poi3dAdapter.getLeftDocument());
      let accessInfo= accessUrl.split('?accessKey=');
      if(accessInfo.length == 2)
        retVal = accessInfo[1];
      else
        callState = "{'errCode':-1,'errText':'Invalid access key'}";
    }
    else
      callState = "{'errCode':-1,'errText':'No user access'}";

    if(_isCallFromIframeHost)
      this.sendMessageToHost("GetDocumentAccessKeyResult", retVal, callState);
    else
      return this.buildReturnString("getDocumentAccessKeyResult", retVal, callState); //nested object -> string
  };//Poi3dHostInterface.getDocumentAccessKey

  this.openLeftUserDocumentByAccessKey = function (accessKey)
  {
    let retVal = "";
    let callState = "{'errCode':0,'errText':''}";

    if(accessKey == undefined)
    {
      callState = "{'errCode':-1,'errText':'No parameter given'}";
      Poi3dHostInterface.sendMessageToHost("OpenLeftUserDocumentByAccessKeyError", "", callState);
      return;
    }

    if(accessKey.length >0)
      Poi3dDocumentLoader.openLeftDocumentByAccessKey(accessKey);
    else
    {
      callState = "{'errCode':-1,'errText':'Invalid access key'}";
      Poi3dHostInterface.sendMessageToHost("OpenLeftUserDocumentByAccessKeyError", "", callState);
    }
  };//Poi3dHostInterface.openLeftUserDocument

  this.setStatusText = function(textToDisplay, animStyle)
  {
    let retVal = "";
    let animStyleVal = "";
    let callState = "{'errCode':0,'errText':''}";

    if(animStyle == undefined)
      animStyleVal = animStyle;

    if(textToDisplay == undefined)
    {
      callState = "{'errCode':-1,'errText':'Not enough parameters given'}";
      Poi3dHostInterface.sendMessageToHost("SetStatusTextError", "", callState);
      return;
    }

    setStatusText(textToDisplay,animStyle);
  };//Poi3dHostInterface.setStatusText

  this.showMsgDlg = function(message)
  {
    let retVal = "";
    let callState = "{'errCode':0,'errText':''}";

    if(message == undefined)
    {
      callState = "{'errCode':-1,'errText':'Not enough parameters given'}";
      Poi3dHostInterface.sendMessageToHost("ShowMsgDlgError", "", callState);
      return;
    }

    showMsgDlg(null,message,"");
  };//Poi3dHostInterface.showMsgDlg

  this.getDocIdsFromLoadedDocument = function()
  {
    let hostId = "";
    let poi3dId = "";
    let retVal = "";
    let callState = "{'errCode':0,'errText':''}";

    if((_poi3dAdapter!=null)&&(_poi3dAdapter.getLeftDocument() != null))
    {
      poi3dId = _poi3dAdapter.getLeftDocument().getDocId();
      hostId = _poi3dAdapter.getLeftDocument().getExternalId();
      retVal = "{'hostId':'" + hostId+ "','poi3dId':'" + poi3dId + "','info':''}";
    }
    else
    {
      retVal = "{'hostId':'','poi3dId':'','info':'No document loaded'}";
      callState = "{'errCode':-1,'errText':'No document loaded'}";
    }

    if(_isCallFromIframeHost)
      Poi3dHostInterface.sendMessageToHost("GetDocIdsFromLoadedDocumentResult", retVal, callState);
    else
    {
      if(_controlVersion > 1.1)
        return this.buildReturnObject("GetDocIdsFromLoadedDocumentResult", retVal, callState);
      else
        return retVal;
    }
  };//Poi3dHostInterface.getDocidFromLoadedDocument

  this.saveDocumentAttachementsToPortal = function()
  {
    let retVal = "";
    let callState = "{'errCode':0,'errText':''}";

    if((_poi3dAdapter!=null)&&(_poi3dAdapter.isDocumentAccessible() == true))
      _poi3dAdapter.saveAttachmentsToStorage(leftModel.getModelName());
    else
      callState = "{'errCode':-1,'errText':'No document loaded'}";

    if(_isCallFromIframeHost)
      Poi3dHostInterface.sendMessageToHost("SaveDocumentAttachementsToPortalResult", retVal, callState);
    else
      return this.buildReturnObject("saveDocumentAttachementsToPortalResult", retVal, callState);
  };//Poi3dHostInterface.saveDocumentAttachementsToPortal

  this.getDocumentAnnotations = function()
  {
    let retVal = "";
    let callState = "{'errCode':0,'errText':''}";

    if((_poi3dAdapter!=null)&&(_poi3dAdapter.getLeftDocument() != null))
      retVal = _poi3dAdapter.getLeftDocument().getAnnotationObject().getAsJsonString();
    else
    {
      retVal = "[]";
      callState = "{'errCode':-1,'errText':'No document loaded'}";
    }

    if(_isCallFromIframeHost)
      Poi3dHostInterface.sendMessageToHost("GetDocumentAnnotationsResult", retVal, callState);
    else
    {
      if(_controlVersion > 1.1)
        return this.buildReturnObject("GetDocumentAnnotationsResult", retVal, callState);
      else
        return retVal;
    }
  };//Poi3dHostInterface.getDocumentAnnotations

  this.getDocumentInstructions = function()
  {
    let retVal = "";
    let callState = "{'errCode':0,'errText':''}";

    if((_poi3dAdapter!=null)&&(_poi3dAdapter.getLeftDocument() != null))
      retVal = _poi3dAdapter.getLeftDocument().getInstructionObject().getAsJsonString();
    else
    {
      retVal = "[]";
      callState = "{'errCode':-1,'errText':'No document loaded'}";
    }

    if(_isCallFromIframeHost)
      Poi3dHostInterface.sendMessageToHost("GetDocumentInstructionsResult", retVal, callState);
    else
    {
      if(_controlVersion > 1.1)
        return this.buildReturnObject("GetDocumentInstructionsResult", retVal, callState);
      else
        return retVal;
    }
  };//Poi3dHostInterface.getDocumentInstructions

  this.getDocumentSensors = function()
  {
    let retVal = "";
    let callState = "{'errCode':0,'errText':''}";

    if((_poi3dAdapter!=null)&&(_poi3dAdapter.getLeftDocument() != null))
      retVal = _poi3dAdapter.getLeftDocument().getSensorObject().getAsJsonString();
    else
    {
      retVal = "[]";
      callState = "{'errCode':-1,'errText':'No document loaded'}";
    }

    if(_isCallFromIframeHost)
      Poi3dHostInterface.sendMessageToHost("GetDocumentSensorsResult", retVal, callState);
    else
    {
      if(_controlVersion > 1.1)
        return this.buildReturnObject("GetDocumentSensorsResult", retVal, callState);
      else
        return retVal;
    }
  };//Poi3dHostInterface.getDocumentSensors

  this.getDocumentViewLocations = function()
  {
    let retVal = "";
    let callState = "{'errCode':0,'errText':''}";

    if((_poi3dAdapter!=null)&&(_poi3dAdapter.getLeftDocument() != null))
      retVal = _poi3dAdapter.getLeftDocument().getViewLocationObject().getAsJsonString();
    else
    {
      retVal = "[]";
      callState = "{'errCode':-1,'errText':'No document loaded'}";
    }

    if(_isCallFromIframeHost)
      Poi3dHostInterface.sendMessageToHost("GetDocumentViewLocationsResult", retVal, callState);
    else
    {
      if(_controlVersion > 1.1)
        return this.buildReturnObject("GetDocumentViewLocationsResult", retVal, callState);
      else
        return retVal;
    }
  };//Poi3dHostInterface.getDocumentViewLocations

  this.getDocumentMaterialSets = function()
  {
    let retVal = "";
    let callState = "{'errCode':0,'errText':''}";

    if((_poi3dAdapter!=null)&&(_poi3dAdapter.getLeftDocument() != null))
      retVal = _poi3dAdapter.getLeftDocument().getMaterialSetObject().getAsJsonString();
    else
    {
      retVal = "[]";
      callState = "{'errCode':-1,'errText':'No document loaded'}";
    }

    if(_isCallFromIframeHost)
      Poi3dHostInterface.sendMessageToHost("GetDocumentMaterialSetsResult", retVal, callState);
    else
    {
      if(_controlVersion > 1.1)
        return this.buildReturnObject("GetDocumentMaterialSetsResult", retVal, callState);
      else
        return retVal;
    }
  };//Poi3dHostInterface.getDocumentMaterialSets

  this.getDocumentFileAttachments = function(jsonString)
  {
    let retVal = "";
    let callState = "{'errCode':0,'errText':''}";

    if((_poi3dAdapter!=null)&&(_poi3dAdapter.getLeftDocument() != null))
      retVal = _poi3dAdapter.getLeftDocument().getFileAttachmentObject().getAsJsonString();
    else
    {
      retVal = "[]";
      callState = "{'errCode':-1,'errText':'No document loaded'}";
    }

    if(_isCallFromIframeHost)
      Poi3dHostInterface.sendMessageToHost("GetDocumentFileAttachmentsResult", retVal, callState);
    else
    {
      if(_controlVersion > 1.1)
        return this.buildReturnObject("GetDocumentFileAttachmentsResult", retVal, callState);
      else
        return retVal;
    }
  };//Poi3dHostInterface.getDocumentFileAttachments

  this.getDocumentBomStructures = function()
  {
    let retVal = "";
    let callState = "{'errCode':0,'errText':''}";

    if((_poi3dAdapter!=null)&&(_poi3dAdapter.getLeftDocument() != null))
      retVal = _poi3dAdapter.getLeftDocument().getBomStructureObject().getAsJsonString();
    else
    {
      retVal = "[]";
      callState = "{'errCode':-1,'errText':'No document loaded'}";
    }

    if(_isCallFromIframeHost)
      Poi3dHostInterface.sendMessageToHost("GetDocumentBomStructuresResult", retVal, callState);
    else
    {
      if(_controlVersion > 1.1)
        return this.buildReturnObject("GetDocumentBomStructuresResult", retVal, callState);
      else
        return retVal;
    }
  };//Poi3dHostInterface.getDocumentBomStructures

  this.getDocumentAttributes = function()
  {
    let retVal = "";
    let callState = "{'errCode':0,'errText':''}";

    if((_poi3dAdapter!=null)&&(_poi3dAdapter.getLeftDocument() != null))
      retVal = _poi3dAdapter.getLeftDocument().getDocAttributeObject().getAsJsonString();
    else
    {
      retVal = "[]";
      callState = "{'errCode':-1,'errText':'No document loaded'}";
    }

    if(_isCallFromIframeHost)
      Poi3dHostInterface.sendMessageToHost("GetDocumentAttributesResult", retVal, callState);
    else
    {
      if(_controlVersion > 1.1)
        return this.buildReturnObject("GetDocumentAttributesResult", retVal, callState);
      else
        return retVal;
    }
  };//Poi3dHostInterface.getDocumentAttributes

  this.setDocumentAnnotations = function(jsonString)
  {
    let retVal = "";
    let callState = "{'errCode':0,'errText':''}";

    if(jsonString == undefined)
      callState = "{'errCode':-1,'errText':'No parameter given'}";
    else
    {
      if((_poi3dAdapter!=null)&&(_poi3dAdapter.getLeftDocument() != null))
        _poi3dAdapter.getLeftDocument().getAnnotationObject().setFromJsonString(jsonString);
      else
        callState = "{'errCode':-1,'errText':'No document loaded'}";
    }

    if(_isCallFromIframeHost)
      Poi3dHostInterface.sendMessageToHost("SetDocumentAnnotationsResult", retVal, callState);
    else
      return this.buildReturnObject("setDocumentAnnotationsResult", retVal, callState);
  };//Poi3dHostInterface.setDocumentAnnotations

  this.setDocumentInstructions = function(jsonString)
  {
    let retVal = "";
    let callState = "{'errCode':0,'errText':''}";

    if(jsonString == undefined)
      callState = "{'errCode':-1,'errText':'No parameter given'}";
    else
    {
      if((_poi3dAdapter!=null)&&(_poi3dAdapter.getLeftDocument() != null))
        _poi3dAdapter.getLeftDocument().getInstructionObject().setFromJsonString(jsonString);
      else
        callState = "{'errCode':-1,'errText':'No document loaded'}";
    }

    if(_isCallFromIframeHost)
      Poi3dHostInterface.sendMessageToHost("SetDocumentInstructionsResult", retVal, callState);
    else
      return this.buildReturnObject("setDocumentAnnotationsResult", retVal, callState);
  };//Poi3dHostInterface.setDocumentInstructions

  this.setDocumentSensors = function(jsonString)
  {
    let retVal = "";
    let callState = "{'errCode':0,'errText':''}";

    if(jsonString == undefined)
      callState = "{'errCode':-1,'errText':'No parameter given'}";
    else
    {
      if((_poi3dAdapter!=null)&&(_poi3dAdapter.getLeftDocument() != null))
        _poi3dAdapter.getLeftDocument().getSensorObject().setFromJsonString(jsonString);
      else
        callState = "{'errCode':-1,'errText':'No document loaded'}";
    }

    if(_isCallFromIframeHost)
      Poi3dHostInterface.sendMessageToHost("SetDocumentSensorsResult", retVal, callState);
    else
      return this.buildReturnObject("setDocumentSensorsResult", retVal, callState);
  };//Poi3dHostInterface.setDocumentSensors

  this.setDocumentViewLocations = function(jsonString)
  {
    let retVal = "";
    let callState = "{'errCode':0,'errText':''}";

    if(jsonString == undefined)
      callState = "{'errCode':-1,'errText':'No parameter given'}";
    else
    {
      if((_poi3dAdapter!=null)&&(_poi3dAdapter.getLeftDocument() != null))
        _poi3dAdapter.getLeftDocument().getViewLocationObject().setFromJsonString(jsonString);
      else
        callState = "{'errCode':-1,'errText':'No document loaded'}";
    }

    if(_isCallFromIframeHost)
      Poi3dHostInterface.sendMessageToHost("SetDocumentViewLocationsResult", retVal, callState);
    else
      return this.buildReturnObject("setDocumentViewLocationsResult", retVal, callState);
  };//Poi3dHostInterface.setDocumentViewLocations

  this.setDocumentMaterialSets = function(jsonString)
  {
    let retVal = "";
    let callState = "{'errCode':0,'errText':''}";

    if(jsonString == undefined)
      callState = "{'errCode':-1,'errText':'No parameter given'}";
    else
    {
      if((_poi3dAdapter!=null)&&(_poi3dAdapter.getLeftDocument() != null))
        _poi3dAdapter.getLeftDocument().getMaterialSetObject().setFromJsonString(jsonString);
      else
        callState = "{'errCode':-1,'errText':'No document loaded'}";
    }

    if(_isCallFromIframeHost)
      Poi3dHostInterface.sendMessageToHost("SetDocumentMaterialSetsResult", retVal, callState);
    else
      return this.buildReturnObject("setDocumentMaterialSetsResult", retVal, callState);
  };//Poi3dHostInterface.setDocumentMaterialSets

  this.setDocumentFileAttachments = function(jsonString)
  {
    let retVal = "";
    let callState = "{'errCode':0,'errText':''}";

    if(jsonString == undefined)
      callState = "{'errCode':-1,'errText':'No parameter given'}";
    else
    {
      if((_poi3dAdapter!=null)&&(_poi3dAdapter.getLeftDocument() != null))
        _poi3dAdapter.getLeftDocument().getFileAttachmentObject().setFromJsonString(jsonString);
      else
        callState = "{'errCode':-1,'errText':'No document loaded'}";
    }

    if(_isCallFromIframeHost)
      Poi3dHostInterface.sendMessageToHost("SetDocumentFileAttachmentsResult", retVal, callState);
    else
      return this.buildReturnObject("setDocumentFileAttachmentsResult", retVal, callState);

  };//Poi3dHostInterface.setDocumentFileAttachments

  this.setDocumentBomStructures = function(jsonString)
  {
    let retVal = "";
    let callState = "{'errCode':0,'errText':''}";

    if(jsonString == undefined)
      callState = "{'errCode':-1,'errText':'No parameter given'}";
    else
    {
      if((_poi3dAdapter!=null)&&(_poi3dAdapter.getLeftDocument() != null))
        _poi3dAdapter.getLeftDocument().getBomStructureObject().setFromJsonString(jsonString);
      else
        callState = "{'errCode':-1,'errText':'No document loaded'}";
    }

    if(_isCallFromIframeHost)
      Poi3dHostInterface.sendMessageToHost("SetDocumentBomStructuresResult", retVal, callState);
    else
      return this.buildReturnObject("setDocumentBomStructuresResult", retVal, callState);
  };//Poi3dHostInterface.setDocumentBomStructures

  this.setDocumentAttributes = function(jsonString)
  {
    let retVal = "";
    let callState = "{'errCode':0,'errText':''}";

    if(jsonString == undefined)
      callState = "{'errCode':-1,'errText':'No parameter given'}";
    else
    {
      if((_poi3dAdapter!=null)&&(_poi3dAdapter.getLeftDocument() != null))
        _poi3dAdapter.getLeftDocument().getDocAttributeObject().setFromJsonString(jsonString);
      else
        callState = "{'errCode':-1,'errText':'No document loaded'}";
    }

    if(_isCallFromIframeHost)
      Poi3dHostInterface.sendMessageToHost("SetDocumentAttributesResult", retVal, callState);
    else
      return this.buildReturnObject("SetDocumentAttributesResult", retVal, callState);
  };//Poi3dHostInterface.setDocumentAttributes
};//Poi3dHostInterface
