<?php
require_once('Poi3d/3rdParty/tcpdf/tcpdf.php');

function getHtmlBom($bomData)
{
  //$htmlText = "<!DOCTYPE html><html><head><title>Poi3d Portal</title></head>";
  //$htmlText .= "<body><h1>Hello World</h1></body></html>";
  
  $htmlText = "<!DOCTYPE html>".
    "<head>".
    	"<meta charset='utf-8'/>".
      "<meta name='viewport' content='width=device-width, initial-scale=1, maximum-scale=1'>".
      "<meta name='google' content='notranslate' />".
      "<style>".
        "*{box-sizing:border-box;-webkit-box-sizing:border-box;-moz-box-sizing:border-box;}".
        "body{font-family:Arial,Helvetica,Geneva,Sans-serif; -webkit-font-smoothing:antialiased;background-color:white;}".
        "h2{text-align:left;font-size:18px;text-transform:uppercase;letter-spacing:1px;color:black;padding:30px 0;}".
        ".table-wrapper{margin:10px 70px 70px;box-shadow:0px 35px 50px rgba( 0, 0, 0, 0.2 );}".
        ".fl-table {border-radius:5px;font-size:12px;font-weight:normal;border:none;border-collapse:collapse;width:100%;max-width:100%;white-space:nowrap;background-color:white;}".
        ".fl-table td, .fl-table th {text-align:left;padding:8px;}".
        ".fl-table td {border-right:1px solid #f8f8f8;font-size:12px;}".
        ".fl-table thead th {color:#ffffff;background-color:#0CA9F2;}".
        ".fl-table thead th:nth-child(odd) {color:#ffffff;background-color:#0A87C1;}".
        ".fl-table tr:nth-child(even) {background-color:#F8F8F8;}".
        "@media (max-width:767px) {".
          ".fl-table {display:block;width:100%;}".
          ".fl-table thead, .fl-table tbody, .fl-table thead th {display:block;}".
          ".fl-table thead th:last-child{border-bottom:none;}".
          ".fl-table thead {float:left;}".
          ".fl-table tbody {width:auto;position:relative;overflow-x:auto;}".
          ".fl-table td, .fl-table th {padding:20px .625em .625em .625em;height:60px;vertical-align:middle;box-sizing:border-box;overflow-x:hidden;overflow-y:auto;width:120px;font-size:13px;text-overflow:ellipsis;}".
          ".fl-table thead th {text-align:left;border-bottom:1px solid #f7f7f9;}".
          ".fl-table tbody tr {display:table-cell;}".
          ".fl-table tbody tr:nth-child(odd) {background-color:none;}".
          ".fl-table tr:nth-child(even) {background-color:transparent;}".
          ".fl-table tr td:nth-child(odd) {background-color:#F8F8F8;border-right:1px solid #E6E4E4;}".
          ".fl-table tr td:nth-child(even) {border-right:1px solid #E6E4E4;}".
          ".fl-table tbody td {display:block;text-align:left;}}".
      "</style>".
    "</head>".
    "<body>";

  $htmlText .= "<h2>HTML-Export: \"" . $bomData->psTtl . "\"</h2>";

  $htmlText .= "<div class='table-wrapper'>".
        "<table class='fl-table'>".
          "<thead>".
          "<tr>".
            "<th>Position Nr.</th>".
            "<th>Count</th>";

  $attributes = $bomData->links[0]->attribs;
	foreach ( $attributes as $att ) {
    $htmlText .= "<th>" . $att->key ."</th>";
  }
  
  $htmlText .= "</tr>".
          "</thead>".
          "<tbody>";
          
  $rowData = $bomData->links;
	foreach ( $rowData as $rd ) {
    $htmlText .= "<tr>";
    $htmlText .= "<td>" . $rd->pNr ."</td>";
    $htmlText .= "<td>" . $rd->cNt ."</td>";
    
    $attributes = $rd->attribs;
  	foreach ( $attributes as $att ) {
      $htmlText .= "<td>" . $att->val ."</td>";
    }
    
    $htmlText .= "</tr>";
  }
          
  $htmlText .= "<tbody>".
        "</table>".
      "</div>".
    "</body>".
  "</html>";
  
	return $htmlText;
}

function generateRandomString($length = 10) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[random_int(0, $charactersLength - 1)];
    }
    return $randomString;
}

function getPdfBom($bomData)
{
  //https://tcpdf.org/docs/srcdoc/TCPDF/classes-TCPDF/
  //https://tcpdf.org/files/examples/example_006.phps
  //https://tcpdf.org/examples/example_006/
  
  $pdfUrl = "FileOutput/" . generateRandomString() . ".pdf";
	$headerRowStyleOddFixed = "width=\"10%\" style=\"text-align:left;color:#ffffff;background-color:#0CA9F2;\"";
	$headerRowStyleEvenFixed = "width=\"20%\" style=\"text-align:left;color:#ffffff;background-color:#0A87C1;\"";
	$headerRowStyleOdd = "style=\"text-align:left;color:#ffffff;background-color:#0CA9F2;\"";
	$headerRowStyleEven = "style=\"text-align:left;color:#ffffff;background-color:#0A87C1;\"";
	$tableRowStyleOdd = "style=\"text-align:left;border-right:1px solid #00000;background-color:#ffffff;\"";
	$tableRowStyleEven = "style=\"text-align:left;border-right:1px solid #f8f8f8;background-color:#F8F8F8;\"";
	$tableCellStyle = "style=\"border-right:1px solid #f8f8f8;\"";

  $tableText = "<table cellpadding=\"8\" style=\"width:100%;\"><thead><tr>".
      "<th width=\"12%\" ". $headerRowStyleOdd .">Position Nr.</th>".
      "<th width=\"6%\" ". $headerRowStyleEven .">Count</th>";
  
  $attributes = $bomData->links[0]->attribs;
  $cols = count($attributes);
  
  if($cols > 0) {
    $itCount = 2;
    $colWidth = intval((100-18)/count($attributes));
  	
  	foreach ( $attributes as $att ) {
  	  if($itCount  % 2 == 0)
        $tableText .= "<th width=\"" . $colWidth . "%\"" . $headerRowStyleOdd .">" . $att->key ."</th>";
      else
        $tableText .= "<th width=\"" . $colWidth . "%\"" . $headerRowStyleEven .">" . $att->key ."</th>";
      
      $itCount++;
    }
  }
    
  $tableText .= "</tr></thead><tbody>";
          
  $rowData = $bomData->links;
  $itCount = 2;
	foreach ( $rowData as $rd ) {
	  if($itCount  % 2 == 0)
      $tableText .= "<tr ". $tableRowStyleOdd .">";
    else
      $tableText .= "<tr ". $tableRowStyleEven .">";

    $tableText .= "<td width=\"12%\" ". $tableCellStyle .">" . $rd->pNr ."</td>";
    $tableText .= "<td width=\"6%\" ". $tableCellStyle .">" . $rd->cNt ."</td>";
    
    if($cols > 0) {
      $attributes = $rd->attribs;
    	foreach ( $attributes as $att ) {
        $tableText .= "<td width=\"" . $colWidth . "%\"" . $tableCellStyle .">" . $att->val ."</td>";
      }
    }  
    $tableText .= "</tr>";
    $itCount++;
  }
          
  $tableText .= "<tbody></table>";
  
	$pdf = new TCPDF('L', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
  $pdf->SetCreator(PDF_CREATOR);
  $pdf->SetAuthor('Poi3d.com');
	$pdf->SetTitle($bomData->psTtl);
	$pdf->SetSubject($bomData->psTtl);
  // set default header data

  $pdf->SetHeaderData("../../../../../Poi3d/Images/Poi3d-Small.png", 10, "BOM-Export", $bomData->psTtl);
  
  // set header and footer fonts
  $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
  $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
  
  // set default monospaced font
  $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
  
  // set margins
  $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
  $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
  $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
  
  // set auto page breaks
  $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
  
  // set image scale factor
  $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

	$pdf->SetFont('dejavusans', '', 10);
	
	$pdf->AddPage();
	
	$pdf->writeHTML($tableText, true, false, true, false, '');

	// display / save PDF
	$pdf->Output(__DIR__ . "/" . $pdfUrl,'F');	

	return $pdfUrl;
}
?>