<?php

/*
 * Copyright CADMAI Software GmbH.
 * All rights reserved.
 *
 * The redistributor / user does not have the right to change, translate,
 * back-develop, decompile or disassemble the software.
 *
 * Redistributions must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Neither the name of CADMAI Software GmbH nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

include ( 'funcs.php' );

$func = $_GET['func'];

$data = json_decode ( $_POST['data'] );

//print_r ( $id );

$output = [
  "mMm" => $func,
  "erC" => 0,
  "erT" => '',
  "srvInfo" => '',
  "dt" => []
];

switch ( $func ) {

  case 'UpdatePwd':
    $output['erC'] = UpdatePwd ( $data, $output['dt'], $output['erT'] );
    break;

  case 'Set2FA':
    $output['erC'] = Set2FA ( $data, $output['dt'], $output['erT'] );
    break;

  case 'DeleteOutputFile':
    $output['erC'] = DeleteOutputFile ( $data, $output['dt'], $output['erT']);
    break;

  case 'ReadPortalConfiguration':
    $output['erC'] = ReadPortalConfiguration ( $data, $output['dt'], $output['erT'], $output['srvInfo']);
    break;

  case 'ReadPortalLicense':
    if( empty( $data->fileName ) || (iCheckFilenameForRead($data->fileName) === false)) {
      $output['erC'] = 1;
      $output['erT'] = 'incorrect function call';
    }
    else
      $output['erC'] = ReadJsonFile ( $data, $output['dt'], $output['erT'], $output['srvInfo']);
    break;

  case 'ReadPortalLanguage':
      $output['erC'] = ReadJsonFile ( $data, $output['dt'], $output['erT'], $output['srvInfo']);
    break;

  case 'ReadOfferOrAnswer':
      $output['erC'] = ReadJsonFile ( $data, $output['dt'], $output['erT'], $output['srvInfo']);
    break;

  case 'ReadUserList':
      $output['erC'] = ReadJsonFile ( $data, $output['dt'], $output['erT'], $output['srvInfo']);
    break;

  case 'ReadMaterials':
      $output['erC'] = ReadJsonFile ( $data, $output['dt'], $output['erT'], $output['srvInfo']);
    break;

  case 'ReloadWorkGroups':
    if( empty( $data->fileName ) || (iCheckFilenameForRead($data->fileName) === false)) {
      $output['erC'] = 1;
      $output['erT'] = 'incorrect function call';
    }
    else
      $output['erC'] = ReadJsonFile ( $data, $output['dt'], $output['erT'], $output['srvInfo']);
    break;

  case 'WritePortalConfiguration':
    $output['erC'] = WritePortalConfiguration ( $data, $output['dt'], $output['erT'], $output['srvInfo'] );
    break;

  case 'LockFile':
    $output['erC'] = LockFile ( $data, $output['dt'], $output['erT'], $output['srvInfo'] );
    break;

  case 'UnlockFile':
    $output['erC'] = UnlockFile ( $data, $output['dt'], $output['erT'], $output['srvInfo'] );
    break;

  case 'SaveFileAttachments':
    $output['erC'] = SaveFileAttachments ( $data, $output['dt'], $output['erT'], $output['srvInfo'] );
    break;

  case 'GetTimestamp':
    $output['erC'] = GetTimestamp ( $data, $output['dt'], $output['erT'] );
    break;

  case 'UploadImage':
    $output['erC'] = UploadImage ( $data, $output['dt'], $output['erT'], $_FILES );
    break;

  case 'UploadZipFile':
    $output['erC'] = UploadZipFile ( $data, $output['dt'], $output['erT'], $_FILES );
    break;

  case 'UploadFile':
    $output['erC'] = UploadFile ( $data, $output['dt'], $output['erT'], $_FILES );
    break;

  case 'CreateUserList':
    $output['erC'] = CreateUserList ( $data, $output['dt'], $output['erT'] );
    break;

  case "ReadUserAccessDataByAdmin":
    $output['erC'] = ReadUserAccessDataByAdmin ( $data, $output['dt'], $output['erT'], $output['srvInfo']);
    break;

  case 'LoadDocumentAttachments':
    $output['erC'] = LoadDocumentAttachments ( $data, $output['dt'], $output['erT'], $output['srvInfo']);
    break;

  case 'LoadGroupAttachments':
    $output['erC'] = LoadGroupAttachments ( $data, $output['dt'], $output['erT'], $output['srvInfo']);
    break;

  case 'ReadAttachment':
    if( empty( $data->fileName ) || (iCheckFilenameForRead($data->fileName) === false)) {
      $output['erC'] = 1;
      $output['erT'] = 'incorrect function call';
    }
    else
      $output['erC'] = ReadJsonFile ( $data, $output['dt'], $output['erT'], $output['srvInfo']);
    break;

  case 'WriteAttachment':
    if( empty( $data->fileName ) || (iCheckFilenameForWrite($data->fileName) === false)) {
      $output['erC'] = 1;
      $output['erT'] = 'incorrect function call';
    }
    else
      $output['erC'] = WriteJsonFile ( $data, $output['dt'], $output['erT'], $output['srvInfo'] );
    break;

  case 'AppendToAttachment':
    if( empty( $data->fileName ) || (iCheckFilenameForWrite($data->fileName) === false)) {
      $output['erC'] = 1;
      $output['erT'] = 'incorrect function call';
    }
    else
      $output['erC'] = AppendToJsonFile ( $data, $output['dt'], $output['erT'], $output['srvInfo'] );
    break;

  case 'WriteUserDocuments':
    if( empty( $data->fileName ) || (iCheckFilenameForWrite($data->fileName) === false)) {
      $output['erC'] = 1;
      $output['erT'] = 'incorrect function call';
    }
    else
      $output['erC'] = WriteJsonFile ( $data, $output['dt'], $output['erT'], $output['srvInfo'] );
    break;

  case 'CheckFileExistance':
    $output['erC'] = CheckFileExistance ( $data, $output['dt'], $output['erT'] );
    break;

  case 'SendEmail':
    $output['erC'] = SendEmail( $data, $output['dt'], $output['erT']);
    break;

  case 'PushMessage':
    $output['erC'] = PushMessage( $data, $output['dt'], $output['erT']);
    break;

  case 'PushSubscribe':
    $output['erC'] = PushSubscribeOrUpdate( $data, $output['dt'], $output['erT']);
    break;

  case 'PushUnsubscribe':
    $output['erC'] = PushUnsubscribe( $data, $output['dt'], $output['erT']);
    break;

  case 'PushUpdate':
    $output['erC'] = PushSubscribeOrUpdate( $data, $output['dt'], $output['erT']);
    break;

  case 'LogOff':
    $output['erC'] = LogOff( $data, $output['dt'], $output['erT']);
    break;

  case 'CheckUserLogins':
    $output['erC'] = CheckUserLogins ( $data, $output['dt'], $output['erT']);
    break;

  //CRUD User ------
  case 'CreateUser':
    $output['erC'] = CreateUser ( $data, $output['dt'], $output['erT'] );
    break;

  case 'ReadUserBaseData':
    $output['erC'] = ReadUserBaseData ( $data, $output['dt'], $output['erT'] );
    break;

  case 'ResetUserPassword':
    $output['erC'] = ResetUserPassword ( $data, $output['dt'], $output['erT'] );
    break;

  case 'ReadUser':
    $output['erC'] = ReadUser ( $data, $output['dt'], $output['erT'] );
    break;

  case 'UpdateUserBaseData':
    $output['erC'] = UpdateUserBaseData ( $data, $output['dt'], $output['erT'] );
    break;

  case 'UpdateUserAccessDataByAdmin':
    $output['erC'] = UpdateUserAccessDataByAdmin ( $data, $output['dt'], $output['erT'] );
    break;

  case 'UpdateUserTypeByAdmin':
    $output['erC'] = UpdateUserTypeByAdmin ( $data, $output['dt'], $output['erT'] );
    break;

  case 'UpdateUser':
    $output['erC'] = UpdateUser ( $data, $output['dt'], $output['erT'] );
    break;

  case 'DeleteUser':
    $output['erC'] = DeleteUser ( $data, $output['dt'], $output['erT'] );
    break;

  //CRUD Document ------
  case 'CreateDocument':
    $output['erC'] = CreateDocument ( $data, $output['dt'], $output['erT'], $_FILES );
    break;

  case 'ReadDocument':
    $output['erC'] = ReadDocument ( $data, $output['dt'], $output['erT'] );
    break;

  case 'UpdateDocument':
    $output['erC'] = UpdateDocument ( $data, $output['dt'], $output['erT'] );
    break;

  case 'DeleteDocument':
    $output['erC'] = DeleteDocument ( $data, $output['dt'], $output['erT'] );
    break;

  case 'TestFunction':
    $output['erC'] = TestFunction ( $data, $output['dt'], $output['erT'] );
    break;

  //CRUD WorkGroup ------
  case 'CreateWorkGroup':
    $output['erC'] = CreateWorkGroup ( $data, $output['dt'], $output['erT'] );
    break;

  case 'ReadWorkGroup':
    $output['erC'] = ReadWorkGroup ( $data, $output['dt'], $output['erT'] );
    break;

  case 'UpdateWorkGroup':
    $output['erC'] = UpdateWorkGroup ( $data, $output['dt'], $output['erT'] );
    break;

  case 'DeleteWorkGroup':
    $output['erC'] = DeleteWorkGroup ( $data, $output['dt'], $output['erT'] );
    break;

  default:
    $output['erC'] = 1;
    $output['erT'] = 'function not implemented';
    break;
}

echo json_encode ( $output );
