<?php

/*
 * Copyright CADMAI Software GmbH.
 * All rights reserved.
 *
 * The redistributor / user does not have the right to change, translate,
 * back-develop, decompile or disassemble the software.
 *
 * Redistributions must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Neither the name of CADMAI Software GmbH nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

include_once ( 'funcs.php' );

if (isset($_GET['file'])) {
	$filename = $_GET['file'];

	if (empty ( $_GET['token'])) {
    if (iCheckGlobalAccess($filename) == false)
  		die("");
	}
	else {
  	$ut = $_GET['token'];
  	$userToken = json_decode ( $ut );

  	if ( !empty ( $userToken->aNm )) {
  		$f = file_get_contents ( 'Poi3dUsers/' . $userToken->aNm . '.json' );
  	}
  	else if ( !empty ( $userToken->uNm )) {
  		$f = file_get_contents ( 'Poi3dUsers/' . $userToken->uNm . '.json' );
  	}
  	else if ( !empty ( $userToken->prof )) {
  		$f = file_get_contents ( $userToken->prof );
  	}
  	else {
  		die("");
  	}

    if ( !empty ( $userToken->prof )) { //check for public document
      if (iCheckGlobalAccess($userToken->prof) == false)
    		die("");
    }
    else {//check user access
    	$user = json_decode ( $f );

    	// overwrite password if received asymmetrical encrypted
    	if ( !empty( $userToken->vDt ) ) {
    		if ( iDecrypt( $userToken->vDt, $vDt, $errorText ) ) {
    			die( 'decryption error: ' . $errorText );
    		}

    		$date = new DateTime();
    		$unix_seconds = $date->setTimezone(new \DateTimeZone('UTC'))->format('U');
    		$unix_seconds = intval( $unix_seconds / 30 );

    		if ( abs( $unix_seconds - $vDt->time ) >= 2 ) {
    			$t_diff = ($unix_seconds - $vDt->time) * 30;
    			die( 'time does not match by ' . $t_diff . ' seconds. Server: ' . $unix_seconds . ', client: ' . $vDt->time );
    		}

    		$userToken->pWd = $vDt->pwd;
    	}

    	if ( !password_verify ( $userToken->pWd, $user->pWd ) ) {
    		die("");
    	}

    	//update log file
    	if ((strpos($filename, '_pv.') == false)&&( empty ( $userToken->aNm ))) {
    		$pathParts = pathinfo ( $filename );

    		if ( file_exists( $pathParts['dirname'] ) && is_dir ( $pathParts['dirname'] ) ) {
    			$logFileName = $pathParts['dirname'] . "/fileAccess.json";
    			//echo $logFileName. "\n";

    			$listEntry = (object) [];
    			$listEntry->dT = date('d-M-Y H:i:s');
    			$listEntry->aL = $user->aL;
    			$listEntry->uId = $user->uId;

        	$json = json_encode ( $listEntry );
        	iAppendContent($logFileName,$json);
    		}
    	}
    }//
  }//if (empty ( $userToken))

	//read content
	$fp = fopen($filename, 'rb');
	header("Content-Type: application/zip");
	header("Content-Length: " . filesize($filename));

	fpassthru($fp);
	exit;
} else {
		// Fallback behaviour goes here
}
?>
